/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.ar;

import com.ibm.hwmca.base.pa.ar.CommonSystemAnalysisRoutine;
import com.ibm.hwmca.fw.pa.ProblemAnalysisManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.xfw.pa.event.CommonServiceAREvent;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DistributedSystemAnalysisRoutine
extends CommonSystemAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPADSART";
    private static final String TRACE_MASKF = "PPADSARF";
    private static final String TRACE_MASKD = "PPADSARD";

    public DistributedSystemAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, this.getClass().getName() + "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKT, this.getClass().getName() + "--> analyze()");
        CommonServiceAREvent ourEvent = (CommonServiceAREvent)event;
        String poolId = ourEvent.getIncidentPoolId();
        IncidentPool thePool = DistributedSystemAnalysisRoutine.getAnalyzingIncidentPool(poolId);
        if (thePool == null) {
            Trace.trace(TRACE_MASKT, "<-- analyze(): no pool to analyze");
            return;
        }
        if (thePool.size() == 0) {
            Trace.trace(TRACE_MASKD, "no incidents in the pool");
        } else if (thePool.size() == 1) {
            Trace.trace(TRACE_MASKD, "only one incident in the pool");
            CommonServiceIncident topInc = (CommonServiceIncident)thePool.iterator().next();
            Trace.trace(TRACE_MASKD, "top (priority=" + topInc.getPriority() + ",refcode=" + topInc.getProblem().getRefcode() + ")");
            ArrayList<CommonServiceIncident> sortedList = new ArrayList<CommonServiceIncident>(1);
            sortedList.add(topInc);
            this.associateFiles(sortedList);
        } else {
            List sortedList = this.sortPoolOnTimePool(thePool);
            thePool.clear();
            Trace.trace(TRACE_MASKD, "the pool is " + thePool.size());
            HashMap systemNtimes = this.correlateIncidentPool(sortedList);
            Set sysKeys = systemNtimes.keySet();
            if (sysKeys == null) {
                Trace.trace(TRACE_MASKD, "how can this be no system keys? ");
                Trace.trace(TRACE_MASKD, "return <-- analyze ");
                return;
            }
            Iterator skI = sysKeys.iterator();
            while (skI.hasNext()) {
                String key = (String)skI.next();
                Trace.trace(TRACE_MASKD, "operating with system " + key);
                HashMap timeNincidents = (HashMap)systemNtimes.get(key);
                if (timeNincidents == null) {
                    Trace.trace(TRACE_MASKD, "how can this be no times and incidents?? for " + key);
                    continue;
                }
                Set tniKeys = timeNincidents.keySet();
                if (tniKeys == null) {
                    Trace.trace(TRACE_MASKD, "how can this be no key in our time n incidents?? for " + key);
                    continue;
                }
                Iterator tniI = tniKeys.iterator();
                while (tniI.hasNext()) {
                    String timeKey = (String)tniI.next();
                    ArrayList timedIncidents = (ArrayList)timeNincidents.get(timeKey);
                    Trace.trace(TRACE_MASKD, key + " timeFrame has of " + timeKey + " has " + timedIncidents.size() + " incidents ");
                    Iterator tiI = timedIncidents.iterator();
                    while (tiI.hasNext()) {
                        CommonServiceIncident csi = (CommonServiceIncident)tiI.next();
                        PIProblem thisProblem = (PIProblem)csi.getProblem();
                        Trace.trace(TRACE_MASKD, key + " incident RefCode " + thisProblem.getRefcode() + " has  a time of " + new Date(thisProblem.getLastReportedTimestamp()));
                    }
                    Collections.sort(timedIncidents);
                    this.swapTop(timedIncidents);
                    this.associateFiles(timedIncidents);
                    Trace.trace(TRACE_MASKD, "pre association timedIncidents.size = " + timedIncidents.size());
                    ArrayList finalList = this.associateProblems(timedIncidents);
                    Trace.trace(TRACE_MASKD, "post association finalList.size = " + finalList.size());
                    Iterator fiI = finalList.iterator();
                    while (fiI.hasNext()) {
                        CommonServiceIncident csi = (CommonServiceIncident)fiI.next();
                        PIProblem thisProblem = (PIProblem)csi.getProblem();
                        Trace.trace(TRACE_MASKD, key + " add the back to pool incident RefCode " + thisProblem.getRefcode() + " has  a time of " + new Date(thisProblem.getLastReportedTimestamp()));
                        thePool.add(csi);
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<-- analyze()");
    }

    private List sortPoolOnTimePool(IncidentPool thePool) {
        ArrayList returnList = new ArrayList();
        Iterator pi = thePool.iterator();
        while (pi.hasNext()) {
            returnList.add(pi.next());
        }
        for (int i = 0; i < returnList.size(); ++i) {
            CommonServiceIncident csiI = (CommonServiceIncident)returnList.get(i);
            for (int y = i + 1; y < returnList.size(); ++y) {
                CommonServiceIncident csiY = (CommonServiceIncident)returnList.get(y);
                if (csiY.getProblem().getLastReportedTimestamp() >= csiI.getProblem().getLastReportedTimestamp()) continue;
                CommonServiceIncident csiHolder = (CommonServiceIncident)returnList.get(i);
                returnList.set(i, csiY);
                returnList.set(y, csiHolder);
            }
        }
        return returnList;
    }

    public HashMap correlateIncidentPool(List ip) {
        ArrayList returnList = new ArrayList();
        HashMap groups = new HashMap();
        HashMap failingSystemsMap = new HashMap();
        Iterator ipI = ip.iterator();
        while (ipI.hasNext()) {
            CommonServiceIncident csi = (CommonServiceIncident)ipI.next();
            CommonProblem cp = csi.getProblem();
            if (!(cp instanceof PIProblem)) {
                Trace.trace(TRACE_MASKD, "this is not an instance piproblem quit now ");
            }
            PIProblem pip = (PIProblem)csi.getProblem();
            Trace.trace(TRACE_MASKD, "operate on this failingSystem " + pip.getFailingSystem().getMTMS());
            if (failingSystemsMap.containsKey(pip.getFailingSystem().getMTMS())) {
                Trace.trace(TRACE_MASKD, "failingSystem was in our add the system and the incident");
                ((ArrayList)failingSystemsMap.get(pip.getFailingSystem().getMTMS())).add(csi);
                continue;
            }
            Trace.trace(TRACE_MASKD, "failingSystem was not in our add the incident to the new arraylist in the map");
            ArrayList<CommonServiceIncident> thisArrayList = new ArrayList<CommonServiceIncident>();
            thisArrayList.add(csi);
            failingSystemsMap.put(pip.getFailingSystem().getMTMS(), thisArrayList);
        }
        Set keys = failingSystemsMap.keySet();
        Iterator kI = keys.iterator();
        HashMap fsysNtime = new HashMap();
        boolean counter = false;
        while (kI.hasNext()) {
            String sysName = (String)kI.next();
            ArrayList incidentsForSystem = (ArrayList)failingSystemsMap.get(sysName);
            Trace.trace(TRACE_MASKD, "system name: ");
            Iterator ifsI = incidentsForSystem.iterator();
            while (ifsI.hasNext()) {
                CommonServiceIncident csi = (CommonServiceIncident)ifsI.next();
                PIProblem pip = (PIProblem)csi.getProblem();
                Trace.trace(TRACE_MASKD, "             problem: timestamp= " + pip.getLastReportedTimestamp() + " as a date " + new Date(pip.getLastReportedTimestamp()));
            }
        }
        kI = keys.iterator();
        while (kI.hasNext()) {
            ArrayList incidentsForSystem = (ArrayList)failingSystemsMap.get(kI.next());
            Iterator ifsI = incidentsForSystem.iterator();
            while (ifsI.hasNext()) {
                CommonServiceIncident csi = (CommonServiceIncident)ifsI.next();
                PIProblem pip = (PIProblem)csi.getProblem();
                this.placeInSysTimeMap(fsysNtime, csi);
                Trace.trace(TRACE_MASKD, "done with this incident ");
            }
        }
        return fsysNtime;
    }

    private void placeInSysTimeMap(HashMap fsysNtime, CommonServiceIncident csi) {
        PIProblem pip = (PIProblem)csi.getProblem();
        PASystem system = pip.getFailingSystem();
        if (!fsysNtime.containsKey(system.getMTMS())) {
            Trace.trace(TRACE_MASKD, "placeInSysTimeMap the system was not in map add new with new base time");
            HashMap timeNincident = new HashMap();
            ArrayList<CommonServiceIncident> thisArrayList = new ArrayList<CommonServiceIncident>();
            thisArrayList.add(csi);
            timeNincident.put(Long.toString(csi.getProblem().getLastReportedTimestamp()), thisArrayList);
            fsysNtime.put(system.getMTMS(), timeNincident);
        } else {
            Trace.trace(TRACE_MASKD, "system existed in our timestamp now check current incident against times in that map");
            CommonProblem cp = csi.getProblem();
            HashMap systemTS = (HashMap)fsysNtime.get(system.getMTMS());
            Set times = systemTS.keySet();
            Iterator tI = times.iterator();
            boolean found = false;
            String keyFound = null;
            Calendar myCalendar = Calendar.getInstance();
            myCalendar.setTimeInMillis(cp.getLastReportedTimestamp());
            Trace.trace(TRACE_MASKD, "current problem date is " + myCalendar.getTime());
            Trace.trace(TRACE_MASKD, "current problem timeinmillis is " + myCalendar.getTimeInMillis());
            Trace.trace(TRACE_MASKD, "now loop through the saved times ");
            long currentEventTS = cp.getLastReportedTimestamp();
            while (tI.hasNext() && keyFound == null) {
                String keyHolder = (String)tI.next();
                long savedTS = Long.parseLong(keyHolder);
                myCalendar.setTimeInMillis(savedTS);
                Trace.trace(TRACE_MASKD, "saved time " + myCalendar.getTime());
                Trace.trace(TRACE_MASKD, "saved time in millis " + myCalendar.getTimeInMillis());
                long diff = 0L;
                if (currentEventTS < savedTS || currentEventTS > savedTS + 5000L) continue;
                Trace.trace(TRACE_MASKD, "this is with in our time window  ");
                keyFound = keyHolder;
            }
            if (keyFound != null) {
                Trace.trace(TRACE_MASKD, " time window was found add incident to list");
                ((ArrayList)systemTS.get(keyFound)).add(csi);
            } else {
                Trace.trace(TRACE_MASKD, " time window was not found create new list and time frame");
                ArrayList<CommonServiceIncident> newArrayList = new ArrayList<CommonServiceIncident>();
                newArrayList.add(csi);
                systemTS.put(Long.toString(cp.getLastReportedTimestamp()), newArrayList);
            }
        }
    }

    private boolean isSpecialSrn(PIProblem problem) {
        return problem.getRefcode().equals("A25-001");
    }

    public boolean isTypeSupported(String type) {
        return true;
    }

    public String[] typesSupported() {
        String[] supports = new String[8];
        return supports;
    }

    public static void main(String[] args) {
    }

    protected ArrayList associateProblems(List timedIncidents) {
        CommonServiceIncident topIncident = (CommonServiceIncident)timedIncidents.get(0);
        CommonProblem topProblem = topIncident.getProblem();
        ArrayList<CommonServiceIncident> finalList = new ArrayList<CommonServiceIncident>();
        Trace.trace(TRACE_MASKD, "finalList.size = " + finalList.size());
        Iterator sortedIter = timedIncidents.iterator();
        sortedIter.next();
        CommonServiceIncident associateIncident = null;
        boolean isAssociate = false;
        finalList.add(topIncident);
        while (sortedIter.hasNext()) {
            associateIncident = (CommonServiceIncident)sortedIter.next();
            isAssociate = topIncident.isAssociate(associateIncident);
            ProblemAnalysisManager pam = ProblemAnalysisManager.getProblemAnalysisManager();
            Iterator srcI = null;
            boolean specialRefcode = false;
            if (pam != null) {
                srcI = pam.getSpecialRefcodes().iterator();
                while (srcI.hasNext()) {
                    if (!((String)srcI.next()).equals(((PIProblem)associateIncident.getProblem()).getRefcode())) continue;
                    Trace.trace(TRACE_MASKD, "specialRefcode  = true");
                    specialRefcode = true;
                }
            }
            if (specialRefcode) {
                finalList.add(associateIncident);
                Trace.trace(TRACE_MASKD, "special srn case keep it in the pool");
                continue;
            }
            if (isAssociate) {
                topProblem.getAssociates().add(associateIncident.getProblem().getUniqueKey());
                associateIncident.getProblem().setAssociateOf(topProblem.getUniqueKey());
                associateIncident.getProblem().addAssociatedFile(topProblem.getAssociatedFileList());
                finalList.add(associateIncident);
                Trace.trace(TRACE_MASKD, "this was an assoctiate add it to the finalList = " + timedIncidents.size());
                continue;
            }
            Trace.trace(TRACE_MASKD, "don't add non-associate problem (priority=" + associateIncident.getPriority() + ",refcode=" + associateIncident.getProblem().getRefcode() + ")");
            topProblem.addSecondaryDataEvent(associateIncident.getProblem().getPrimaryDataEvent());
        }
        Trace.trace(TRACE_MASKD, "finalList.size = " + finalList.size());
        return finalList;
    }
}

